﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using System.IO;
using System.Data;
using UnityStandardAssets.CrossPlatformInput;
using UnityStandardAssets.Vehicles.Car;
using System;
using Unity.Mathematics;

public class CarControlSystem : MyCar
{

    // Start is called before the first frame update

    float InputSpeed = 20;

    private float CarSpeed()
    {
         return transform.InverseTransformVector(GetComponent<Rigidbody>().velocity).z;
    }

    float GetPathQuality(int Pos)
    {
        const int n = 20;
        float res = 0;
        for (int i = 0; i < n; i++)
        {
            var v1 = Road[(Pos + 1) % Road.Count].Pos - Road[(Pos + 0) % Road.Count].Pos;
            var v2 = Road[(Pos + 2) % Road.Count].Pos - Road[(Pos + 1) % Road.Count].Pos;
            var ang = Math.Abs(Vector3.Angle(v1, v2));
            res += ang / v1.magnitude;
            Pos += 1;
        }
        res /= n;
        return 1 / (res * 0.5f + 1);
    }

    float lastPeedle = 0;
    bool MustGoBack = true;
    private float GetPeedle()
    {
        //lastPeedle = Mathf.Clamp(lastPeedle + (InputSpeed - CarSpeed()), -1, 1);
        return (InputSpeed - CarSpeed()) * 1000;
    }

    private float GetSteering()
    {
        var tr = Road[TargetIdx];
        var Dir = transform.InverseTransformVector(tr.Pos - transform.position).normalized;

        

        var R = new System.Random();
        InputSpeed = InputSpeed - Math.Abs(Dir.x * CarSpeed()) * 3 + (float)(R.NextDouble() - 0.5f) * 0.1f; ;

        //Debug.Log("Inputspeed: " + InputSpeed + "speed: " + CarSpeed() + " Steering: " + Dir.x);

       return Dir.x * 2 + (float)(R.NextDouble() - 0.5f) * 0.1f;
    }

    // Update is called once per frame
    void FixedUpdate()
    {
        float h = CrossPlatformInputManager.GetAxis("Horizontal");
        float v = CrossPlatformInputManager.GetAxis("Vertical");
        float j = CrossPlatformInputManager.GetAxis("Jump");
        if (!RaceStated)
        {
            h = 0;
            v = 0;
            j = 1;
        }
        else
        {
            UpdateTarget();
            InputSpeed = 60 * GetPathQuality(TargetIdx);
            h = GetSteering();
            v = GetPeedle();
            if (MustGoBack)
            {
                MustGoBack = false;
                v = -1;
            }
        }
        m_Car.Move(h, v, v, j);
    }
}
